/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import java.awt.Color;
import java.awt.Graphics2D;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.GridPane;
import org.apache.pivot.wtk.GridPaneListener;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.skin.ContainerSkin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridPaneSkin
extends ContainerSkin
implements GridPane.Skin,
GridPaneListener {
    private Insets padding = Insets.NONE;
    private int horizontalSpacing = 0;
    private int verticalSpacing = 0;
    private boolean showHorizontalGridLines = false;
    private boolean showVerticalGridLines = false;
    private Color horizontalGridColor = Color.BLACK;
    private Color verticalGridColor = Color.BLACK;
    private int cellWidth = 0;
    private int cellHeight = 0;

    @Override
    public void install(Component component) {
        super.install(component);
        GridPane gridPane = (GridPane)component;
        gridPane.getGridPaneListeners().add((Object)this);
    }

    @Override
    public int getPreferredWidth(int height) {
        GridPane gridPane = (GridPane)this.getComponent();
        GridPane.RowSequence rows = gridPane.getRows();
        int columnCount = gridPane.getColumnCount();
        int rowCount = rows.getLength();
        Metadata metadata = new Metadata();
        int cellHeight = this.getCellHeight(height, metadata);
        int preferredCellWidth = 0;
        for (int i = 0; i < rowCount; ++i) {
            GridPane.Row row = rows.get(i);
            int n = row.getLength();
            for (int j = 0; j < n && j < columnCount; ++j) {
                Component component = row.get(j);
                if (component == null || !component.isVisible()) continue;
                preferredCellWidth = Math.max(preferredCellWidth, component.getPreferredWidth(cellHeight));
            }
        }
        int preferredWidth = this.padding.left + this.padding.right + metadata.visibleColumnCount * preferredCellWidth;
        if (metadata.visibleColumnCount > 1) {
            preferredWidth += (metadata.visibleColumnCount - 1) * this.horizontalSpacing;
        }
        return preferredWidth;
    }

    @Override
    public int getPreferredHeight(int width) {
        GridPane gridPane = (GridPane)this.getComponent();
        GridPane.RowSequence rows = gridPane.getRows();
        int columnCount = gridPane.getColumnCount();
        int rowCount = rows.getLength();
        Metadata metadata = new Metadata();
        int cellWidth = this.getCellWidth(width, metadata);
        int preferredCellHeight = 0;
        for (int i = 0; i < rowCount; ++i) {
            GridPane.Row row = rows.get(i);
            int n = row.getLength();
            for (int j = 0; j < n && j < columnCount; ++j) {
                Component component = row.get(j);
                if (component == null || !component.isVisible()) continue;
                preferredCellHeight = Math.max(preferredCellHeight, component.getPreferredHeight(cellWidth));
            }
        }
        int preferredHeight = this.padding.top + this.padding.bottom + metadata.visibleRowCount * preferredCellHeight;
        if (metadata.visibleRowCount > 1) {
            preferredHeight += (metadata.visibleRowCount - 1) * this.verticalSpacing;
        }
        return preferredHeight;
    }

    @Override
    public Dimensions getPreferredSize() {
        GridPane gridPane = (GridPane)this.getComponent();
        GridPane.RowSequence rows = gridPane.getRows();
        int columnCount = gridPane.getColumnCount();
        int rowCount = rows.getLength();
        Metadata metadata = new Metadata();
        int preferredCellHeight = 0;
        int preferredCellWidth = 0;
        for (int i = 0; i < rowCount; ++i) {
            GridPane.Row row = rows.get(i);
            int n = row.getLength();
            for (int j = 0; j < n && j < columnCount; ++j) {
                Component component = row.get(j);
                if (component == null || !component.isVisible()) continue;
                Dimensions d = component.getPreferredSize();
                preferredCellHeight = Math.max(preferredCellHeight, d.height);
                preferredCellWidth = Math.max(preferredCellWidth, d.width);
            }
        }
        int preferredWidth = this.padding.left + this.padding.right + metadata.visibleColumnCount * preferredCellWidth;
        if (metadata.visibleColumnCount > 1) {
            preferredWidth += (metadata.visibleColumnCount - 1) * this.horizontalSpacing;
        }
        int preferredHeight = this.padding.top + this.padding.bottom + metadata.visibleRowCount * preferredCellHeight;
        if (metadata.visibleRowCount > 1) {
            preferredHeight += (metadata.visibleRowCount - 1) * this.verticalSpacing;
        }
        return new Dimensions(preferredWidth, preferredHeight);
    }

    @Override
    public int getBaseline(int width, int height) {
        GridPane gridPane = (GridPane)this.getComponent();
        GridPane.RowSequence rows = gridPane.getRows();
        int columnCount = gridPane.getColumnCount();
        int rowCount = rows.getLength();
        Metadata metadata = new Metadata();
        int cellWidth = this.getCellWidth(width, metadata);
        int cellHeight = this.getCellHeight(height, metadata);
        int baseline = -1;
        int rowY = this.padding.top;
        for (int i = 0; i < rowCount && baseline == -1; ++i) {
            if (!metadata.isRowVisible(i)) continue;
            GridPane.Row row = rows.get(i);
            int n = row.getLength();
            for (int j = 0; j < n && j < columnCount && baseline == -1; ++j) {
                Component component = row.get(j);
                if (component == null || !component.isVisible() || (baseline = component.getBaseline(cellWidth, cellHeight)) == -1) continue;
                baseline += rowY;
            }
            rowY += cellHeight + this.verticalSpacing;
        }
        return baseline;
    }

    @Override
    public void layout() {
        GridPane gridPane = (GridPane)this.getComponent();
        GridPane.RowSequence rows = gridPane.getRows();
        int columnCount = gridPane.getColumnCount();
        int rowCount = rows.getLength();
        int width = this.getWidth();
        int height = this.getHeight();
        Metadata metadata = new Metadata();
        this.cellWidth = this.getCellWidth(width, metadata);
        this.cellHeight = this.getCellHeight(height, metadata);
        int componentY = this.padding.top;
        for (int i = 0; i < rowCount; ++i) {
            if (!metadata.isRowVisible(i)) continue;
            GridPane.Row row = rows.get(i);
            int componentX = this.padding.left;
            int n = row.getLength();
            for (int j = 0; j < n && j < columnCount; ++j) {
                Component component = row.get(j);
                if (component != null && component.isVisible()) {
                    component.setLocation(componentX, componentY);
                    component.setSize(this.cellWidth, this.cellHeight);
                }
                if (!metadata.isColumnVisible(j)) continue;
                componentX += this.cellWidth + this.horizontalSpacing;
            }
            componentY += this.cellHeight + this.verticalSpacing;
        }
    }

    @Override
    public void paint(Graphics2D graphics) {
        super.paint(graphics);
        GridPane gridPane = (GridPane)this.getComponent();
        GridPane.RowSequence rows = gridPane.getRows();
        int columnCount = gridPane.getColumnCount();
        int rowCount = rows.getLength();
        int width = this.getWidth();
        int height = this.getHeight();
        Metadata metadata = new Metadata();
        if (this.showHorizontalGridLines && this.verticalSpacing > 0 && rowCount > 1) {
            graphics.setPaint(this.horizontalGridColor);
            int rowY = this.padding.top + (this.cellHeight + this.verticalSpacing);
            for (int i = 1; i < rowCount; ++i) {
                if (!metadata.isRowVisible(i - 1)) continue;
                int gridY = Math.max(rowY - (int)Math.ceil((float)this.verticalSpacing * 0.5f), 0);
                GraphicsUtilities.drawLine(graphics, 0, gridY, width, Orientation.HORIZONTAL);
                rowY += this.cellHeight + this.verticalSpacing;
            }
        }
        if (this.showVerticalGridLines && this.horizontalSpacing > 0 && columnCount > 1) {
            graphics.setPaint(this.verticalGridColor);
            int columnX = this.padding.left + (this.cellWidth + this.horizontalSpacing);
            for (int j = 1; j < columnCount; ++j) {
                if (!metadata.isColumnVisible(j - 1)) continue;
                int gridX = Math.max(columnX - (int)Math.ceil((float)this.horizontalSpacing * 0.5f), 0);
                GraphicsUtilities.drawLine(graphics, gridX, 0, height, Orientation.VERTICAL);
                columnX += this.cellWidth + this.horizontalSpacing;
            }
        }
    }

    private int getCellWidth(int width, Metadata metadata) {
        int cellWidth = -1;
        if (width != -1) {
            int clientWidth = width - this.padding.left - this.padding.right;
            if (metadata.visibleColumnCount > 1) {
                clientWidth -= (metadata.visibleColumnCount - 1) * this.horizontalSpacing;
            }
            clientWidth = Math.max(0, clientWidth);
            cellWidth = metadata.visibleColumnCount == 0 ? 0 : clientWidth / metadata.visibleColumnCount;
        }
        return cellWidth;
    }

    private int getCellHeight(int height, Metadata metadata) {
        int cellHeight = -1;
        if (height != -1) {
            int clientHeight = height - this.padding.top - this.padding.bottom;
            if (metadata.visibleRowCount > 1) {
                clientHeight -= (metadata.visibleRowCount - 1) * this.verticalSpacing;
            }
            clientHeight = Math.max(0, clientHeight);
            cellHeight = metadata.visibleRowCount == 0 ? 0 : clientHeight / metadata.visibleRowCount;
        }
        return cellHeight;
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.padding = padding;
        this.invalidateComponent();
    }

    public final void setPadding(int padding) {
        this.setPadding(new Insets(padding));
    }

    public final void setPadding(Dictionary<String, ?> padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(new Insets(padding));
    }

    public final void setPadding(String padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(Insets.decode(padding));
    }

    public int getHorizontalSpacing() {
        return this.horizontalSpacing;
    }

    public void setHorizontalSpacing(int horizontalSpacing) {
        if (horizontalSpacing < 0) {
            throw new IllegalArgumentException("horizontalSpacing is negative");
        }
        this.horizontalSpacing = horizontalSpacing;
        this.invalidateComponent();
    }

    public int getVerticalSpacing() {
        return this.verticalSpacing;
    }

    public void setVerticalSpacing(int verticalSpacing) {
        if (verticalSpacing < 0) {
            throw new IllegalArgumentException("verticalSpacing is negative");
        }
        this.verticalSpacing = verticalSpacing;
        this.invalidateComponent();
    }

    public boolean getShowHorizontalGridLines() {
        return this.showHorizontalGridLines;
    }

    public void setShowHorizontalGridLines(boolean showHorizontalGridLines) {
        this.showHorizontalGridLines = showHorizontalGridLines;
        this.repaintComponent();
    }

    public boolean getShowVerticalGridLines() {
        return this.showVerticalGridLines;
    }

    public void setShowVerticalGridLines(boolean showVerticalGridLines) {
        this.showVerticalGridLines = showVerticalGridLines;
        this.repaintComponent();
    }

    public Color getHorizontalGridColor() {
        return this.horizontalGridColor;
    }

    public void setHorizontalGridColor(Color horizontalGridColor) {
        if (horizontalGridColor == null) {
            throw new IllegalArgumentException("horizontalGridColor is null.");
        }
        this.horizontalGridColor = horizontalGridColor;
        if (this.showHorizontalGridLines || this.showVerticalGridLines) {
            this.repaintComponent();
        }
    }

    public final void setHorizontalGridColor(String horizontalGridColor) {
        if (horizontalGridColor == null) {
            throw new IllegalArgumentException("horizontalGridColor is null.");
        }
        this.setHorizontalGridColor(GraphicsUtilities.decodeColor(horizontalGridColor));
    }

    public Color getVerticalGridColor() {
        return this.verticalGridColor;
    }

    public void setVerticalGridColor(Color verticalGridColor) {
        if (verticalGridColor == null) {
            throw new IllegalArgumentException("verticalGridColor is null.");
        }
        this.verticalGridColor = verticalGridColor;
        if (this.showHorizontalGridLines || this.showVerticalGridLines) {
            this.repaintComponent();
        }
    }

    public final void setVerticalGridColor(String verticalGridColor) {
        if (verticalGridColor == null) {
            throw new IllegalArgumentException("verticalGridColor is null.");
        }
        this.setVerticalGridColor(GraphicsUtilities.decodeColor(verticalGridColor));
    }

    @Override
    public int getRowAt(int y) {
        GridPane gridPane = (GridPane)this.getComponent();
        GridPane.RowSequence rows = gridPane.getRows();
        int rowCount = rows.getLength();
        int rowIndex = -1;
        int rowY = this.padding.top;
        for (int i = 0; rowY <= y && i < rowCount; rowY += this.cellHeight + this.verticalSpacing, ++i) {
            if (y >= rowY + this.cellHeight) continue;
            rowIndex = i;
            break;
        }
        return rowIndex;
    }

    @Override
    public Bounds getRowBounds(int row) {
        GridPane gridPane = (GridPane)this.getComponent();
        GridPane.RowSequence rows = gridPane.getRows();
        int rowCount = rows.getLength();
        if (row < 0 || row >= rowCount) {
            throw new IndexOutOfBoundsException(String.valueOf(row));
        }
        int rowY = this.padding.top;
        for (int i = 0; i < row; ++i) {
            rowY += this.cellHeight + this.verticalSpacing;
        }
        return new Bounds(0, rowY, this.getWidth(), this.cellHeight);
    }

    @Override
    public int getColumnAt(int x) {
        GridPane gridPane = (GridPane)this.getComponent();
        int columnCount = gridPane.getColumnCount();
        int columnIndex = -1;
        int j = 0;
        for (int columnX = this.padding.left; columnX <= x && j < columnCount; columnX += this.cellWidth + this.horizontalSpacing, ++j) {
            if (x >= columnX + this.cellWidth) continue;
            columnIndex = j;
            break;
        }
        return columnIndex;
    }

    @Override
    public Bounds getColumnBounds(int column) {
        GridPane gridPane = (GridPane)this.getComponent();
        int columnCount = gridPane.getColumnCount();
        if (column < 0 || column >= columnCount) {
            throw new IndexOutOfBoundsException(String.valueOf(column));
        }
        int columnX = this.padding.left;
        for (int j = 0; j < column; ++j) {
            columnX += this.cellWidth + this.horizontalSpacing;
        }
        return new Bounds(columnX, 0, this.cellWidth, this.getHeight());
    }

    @Override
    public void columnCountChanged(GridPane gridPane, int previousColumnCount) {
        this.invalidateComponent();
    }

    @Override
    public void rowInserted(GridPane gridPane, int index) {
        this.invalidateComponent();
    }

    @Override
    public void rowsRemoved(GridPane gridPane, int index, Sequence<GridPane.Row> rows) {
        this.invalidateComponent();
    }

    @Override
    public void cellInserted(GridPane.Row row, int column) {
        this.invalidateComponent();
    }

    @Override
    public void cellsRemoved(GridPane.Row row, int column, Sequence<Component> removed) {
        this.invalidateComponent();
    }

    @Override
    public void cellUpdated(GridPane.Row row, int column, Component previousComponent) {
        this.invalidateComponent();
    }

    protected final class Metadata {
        public final int visibleRowCount;
        public final int visibleColumnCount;
        private boolean[] visibleRows;
        private boolean[] visibleColumns;

        public Metadata() {
            GridPane gridPane = (GridPane)GridPaneSkin.this.getComponent();
            GridPane.RowSequence rows = gridPane.getRows();
            int columnCount = gridPane.getColumnCount();
            int rowCount = rows.getLength();
            this.visibleRows = new boolean[rowCount];
            this.visibleColumns = new boolean[columnCount];
            int visibleRowCount = 0;
            int visibleColumnCount = 0;
            for (int i = 0; i < rowCount; ++i) {
                GridPane.Row row = rows.get(i);
                int n = row.getLength();
                for (int j = 0; j < n && j < columnCount; ++j) {
                    Component component = row.get(j);
                    if (component == null || !component.isVisible()) continue;
                    if (!this.visibleRows[i]) {
                        ++visibleRowCount;
                        this.visibleRows[i] = true;
                    }
                    if (this.visibleColumns[j]) continue;
                    ++visibleColumnCount;
                    this.visibleColumns[j] = true;
                }
            }
            this.visibleRowCount = visibleRowCount;
            this.visibleColumnCount = visibleColumnCount;
        }

        public boolean isRowVisible(int rowIndex) {
            return this.visibleRows[rowIndex];
        }

        public boolean isColumnVisible(int columnIndex) {
            return this.visibleColumns[columnIndex];
        }
    }
}

