/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import org.apache.pivot.wtk.skin.TextPaneSkin;
import org.apache.pivot.wtk.skin.TextPaneSkinListItemView;
import org.apache.pivot.wtk.skin.TextPaneSkinListView;
import org.apache.pivot.wtk.skin.TextPaneSkinNodeView;
import org.apache.pivot.wtk.text.BulletedList;
import org.apache.pivot.wtk.text.BulletedListListener;

class TextPaneSkinBulletedListView
extends TextPaneSkinListView
implements BulletedListListener {
    public TextPaneSkinBulletedListView(TextPaneSkin textPaneSkin, BulletedList bulletedList) {
        super(textPaneSkin, bulletedList);
    }

    protected void attach() {
        super.attach();
        BulletedList bulletedList = (BulletedList)this.getNode();
        bulletedList.getBulletedListListeners().add((Object)this);
    }

    protected void detach() {
        super.detach();
        BulletedList bulletedList = (BulletedList)this.getNode();
        bulletedList.getBulletedListListeners().remove((Object)this);
    }

    public void validate() {
        if (!this.isValid()) {
            TextPaneSkinListItemView listItemView;
            BulletedList bulletedList = (BulletedList)this.getNode();
            for (TextPaneSkinNodeView nodeView : this) {
                listItemView = (TextPaneSkinListItemView)nodeView;
                switch (bulletedList.getStyle()) {
                    case CIRCLE: {
                        listItemView.setIndexText("\u2022 ");
                        break;
                    }
                    case CIRCLE_OUTLINE: {
                        listItemView.setIndexText("\u25e6 ");
                    }
                }
            }
            this.maxIndexTextWidth = 0;
            for (TextPaneSkinNodeView nodeView : this) {
                listItemView = (TextPaneSkinListItemView)nodeView;
                this.maxIndexTextWidth = Math.max(this.maxIndexTextWidth, listItemView.getIndexTextWidth());
            }
            super.validate();
        }
    }

    public void styleChanged(BulletedList bulletedList, BulletedList.Style previousStyle) {
        this.invalidate();
    }
}

