/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.skin.TextPaneSkinNodeView;
import org.apache.pivot.wtk.text.Element;
import org.apache.pivot.wtk.text.ElementListener;
import org.apache.pivot.wtk.text.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class TextPaneSkinElementView
extends TextPaneSkinNodeView
implements Sequence<TextPaneSkinNodeView>,
Iterable<TextPaneSkinNodeView>,
ElementListener {
    private ArrayList<TextPaneSkinNodeView> nodeViews = new ArrayList();

    public TextPaneSkinElementView(Element element) {
        super(element);
    }

    @Override
    protected void attach() {
        super.attach();
        Element element = (Element)this.getNode();
        element.getElementListeners().add((Object)this);
    }

    @Override
    protected void detach() {
        Element element = (Element)this.getNode();
        element.getElementListeners().remove((Object)this);
        for (TextPaneSkinNodeView nodeView : this) {
            nodeView.detach();
        }
        super.detach();
    }

    public int add(TextPaneSkinNodeView nodeView) {
        int index = this.getLength();
        this.insert(nodeView, index);
        return index;
    }

    public void insert(TextPaneSkinNodeView nodeView, int index) {
        nodeView.setParent(this);
        nodeView.attach();
        this.nodeViews.insert((Object)nodeView, index);
    }

    public TextPaneSkinNodeView update(int index, TextPaneSkinNodeView nodeView) {
        throw new UnsupportedOperationException();
    }

    public int remove(TextPaneSkinNodeView nodeView) {
        int index = this.indexOf(nodeView);
        if (index != -1) {
            this.remove(index, 1);
        }
        return index;
    }

    public Sequence<TextPaneSkinNodeView> remove(int index, int count) {
        Sequence removed = this.nodeViews.remove(index, count);
        int n = removed.getLength();
        for (int i = 0; i < n; ++i) {
            TextPaneSkinNodeView nodeView = (TextPaneSkinNodeView)removed.get(i);
            nodeView.setParent(null);
            nodeView.detach();
        }
        return removed;
    }

    public TextPaneSkinNodeView get(int index) {
        return (TextPaneSkinNodeView)this.nodeViews.get(index);
    }

    public int indexOf(TextPaneSkinNodeView nodeView) {
        return this.nodeViews.indexOf((Object)nodeView);
    }

    public int getLength() {
        return this.nodeViews.getLength();
    }

    @Override
    public void paint(Graphics2D graphics) {
        Bounds paintBounds = new Bounds(0, 0, this.getWidth(), this.getHeight());
        Rectangle clipBounds = graphics.getClipBounds();
        if (clipBounds != null) {
            paintBounds = paintBounds.intersect(new Bounds(clipBounds));
        }
        for (TextPaneSkinNodeView nodeView : this.nodeViews) {
            Bounds nodeViewBounds = nodeView.getBounds();
            if (!nodeViewBounds.intersects(paintBounds)) continue;
            Graphics2D nodeViewGraphics = (Graphics2D)graphics.create();
            nodeViewGraphics.translate(nodeViewBounds.x, nodeViewBounds.y);
            Color styledBackgroundColor = this.getStyledBackgroundColor();
            if (styledBackgroundColor != null) {
                nodeViewGraphics.setColor(styledBackgroundColor);
                nodeViewGraphics.fillRect(nodeViewBounds.x, nodeViewBounds.y, nodeViewBounds.width, nodeViewBounds.height);
            }
            nodeView.paint(nodeViewGraphics);
            nodeViewGraphics.dispose();
        }
    }

    private Color getStyledBackgroundColor() {
        Color backgroundColor = null;
        for (Node node = this.getNode(); !(node == null || node instanceof Element && (backgroundColor = ((Element)node).getBackgroundColor()) != null); node = node.getParent()) {
        }
        return backgroundColor;
    }

    @Override
    public Bounds getCharacterBounds(int offset) {
        Bounds characterBounds = null;
        int n = this.nodeViews.getLength();
        for (int i = 0; i < n; ++i) {
            TextPaneSkinNodeView nodeView = (TextPaneSkinNodeView)this.nodeViews.get(i);
            int nodeViewOffset = nodeView.getOffset();
            int characterCount = nodeView.getCharacterCount();
            if (offset < nodeViewOffset || offset >= nodeViewOffset + characterCount) continue;
            characterBounds = nodeView.getCharacterBounds(offset - nodeViewOffset);
            if (characterBounds == null) break;
            characterBounds = characterBounds.translate(nodeView.getX(), nodeView.getY());
            break;
        }
        if (characterBounds != null) {
            characterBounds = characterBounds.intersect(0, 0, this.getWidth(), this.getHeight());
        }
        return characterBounds;
    }

    @Override
    public void nodeInserted(Element element, int index) {
        this.invalidate();
    }

    @Override
    public void nodesRemoved(Element element, int index, Sequence<Node> nodes) {
        this.invalidate();
    }

    @Override
    public void fontChanged(Element element, Font previousFont) {
        this.invalidate();
    }

    @Override
    public void backgroundColorChanged(Element element, Color previousBackgroundColor) {
        this.repaint();
    }

    @Override
    public void foregroundColorChanged(Element element, Color previousForegroundColor) {
        this.repaint();
    }

    @Override
    public void underlineChanged(Element element) {
        this.repaint();
    }

    @Override
    public void strikethroughChanged(Element element) {
        this.repaint();
    }

    @Override
    public Iterator<TextPaneSkinNodeView> iterator() {
        return new ImmutableIterator((Iterator)this.nodeViews.iterator());
    }
}

