/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import java.util.Locale;
import org.apache.pivot.wtk.skin.TextPaneSkin;
import org.apache.pivot.wtk.skin.TextPaneSkinListItemView;
import org.apache.pivot.wtk.skin.TextPaneSkinListView;
import org.apache.pivot.wtk.skin.TextPaneSkinNodeView;
import org.apache.pivot.wtk.text.NumberedList;
import org.apache.pivot.wtk.text.NumberedListListener;

class TextPaneSkinNumberedListView
extends TextPaneSkinListView
implements NumberedListListener {
    private static final RomanValue[] ROMAN_VALUE_TABLE = new RomanValue[]{new RomanValue(1000, "M"), new RomanValue(900, "CM"), new RomanValue(500, "D"), new RomanValue(400, "CD"), new RomanValue(100, "C"), new RomanValue(90, "XC"), new RomanValue(50, "L"), new RomanValue(40, "XL"), new RomanValue(10, "X"), new RomanValue(9, "IX"), new RomanValue(5, "V"), new RomanValue(4, "IV"), new RomanValue(1, "I")};

    private static String int2roman(int n) {
        StringBuffer result = new StringBuffer(10);
        for (RomanValue equiv : ROMAN_VALUE_TABLE) {
            while (n >= equiv.integerVal) {
                n -= equiv.integerVal;
                result.append(equiv.romanNumeral);
            }
        }
        return result.toString();
    }

    private static String int2alpha(int n) {
        return (char)(65 + n - 1) + "";
    }

    public TextPaneSkinNumberedListView(TextPaneSkin textPaneSkin, NumberedList numberedList) {
        super(textPaneSkin, numberedList);
    }

    protected void attach() {
        super.attach();
        NumberedList numberedList = (NumberedList)this.getNode();
        numberedList.getNumberedListListeners().add((Object)this);
    }

    protected void detach() {
        super.detach();
        NumberedList numberedList = (NumberedList)this.getNode();
        numberedList.getNumberedListListeners().remove((Object)this);
    }

    public void validate() {
        if (!this.isValid()) {
            TextPaneSkinListItemView listItemView;
            NumberedList numberedList = (NumberedList)this.getNode();
            int index = 1;
            for (TextPaneSkinNodeView nodeView : this) {
                listItemView = (TextPaneSkinListItemView)nodeView;
                switch (numberedList.getStyle()) {
                    case DECIMAL: {
                        listItemView.setIndexText(index + ". ");
                        break;
                    }
                    case LOWER_ALPHA: {
                        listItemView.setIndexText(TextPaneSkinNumberedListView.int2alpha(index).toLowerCase(Locale.ENGLISH) + ". ");
                        break;
                    }
                    case UPPER_ALPHA: {
                        listItemView.setIndexText(TextPaneSkinNumberedListView.int2alpha(index) + ". ");
                        break;
                    }
                    case LOWER_ROMAN: {
                        listItemView.setIndexText(TextPaneSkinNumberedListView.int2roman(index).toLowerCase(Locale.ENGLISH) + ". ");
                        break;
                    }
                    case UPPER_ROMAN: {
                        listItemView.setIndexText(TextPaneSkinNumberedListView.int2roman(index) + ". ");
                    }
                }
                ++index;
            }
            this.maxIndexTextWidth = 0;
            for (TextPaneSkinNodeView nodeView : this) {
                listItemView = (TextPaneSkinListItemView)nodeView;
                this.maxIndexTextWidth = Math.max(this.maxIndexTextWidth, listItemView.getIndexTextWidth());
            }
            super.validate();
        }
    }

    public void styleChanged(NumberedList numberedList, NumberedList.Style previousStyle) {
        this.invalidate();
    }

    private static class RomanValue {
        public final int integerVal;
        public final String romanNumeral;

        public RomanValue(int integerVal, String romanNumeral) {
            this.integerVal = integerVal;
            this.romanNumeral = romanNumeral;
        }
    }
}

