/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.text;

import java.util.Iterator;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.text.Element;
import org.apache.pivot.wtk.text.NodeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Node {
    private Element parent = null;
    private int offset = 0;
    private NodeListenerList nodeListeners = new NodeListenerList();

    public Element getParent() {
        return this.parent;
    }

    protected void setParent(Element parent) {
        Element previousParent = this.parent;
        if (previousParent != parent) {
            this.parent = parent;
            this.nodeListeners.parentChanged(this, previousParent);
        }
    }

    public int getOffset() {
        return this.offset;
    }

    protected void setOffset(int offset) {
        int previousOffset = this.offset;
        if (previousOffset != offset) {
            this.offset = offset;
            this.nodeListeners.offsetChanged(this, previousOffset);
        }
    }

    public int getDocumentOffset() {
        return this.parent == null ? 0 : this.parent.getDocumentOffset() + this.offset;
    }

    public abstract void insertRange(Node var1, int var2);

    public abstract Node removeRange(int var1, int var2);

    public Node replaceRange(int offset, int characterCount, Node range) {
        Node removed = this.removeRange(offset, characterCount);
        this.insertRange(range, offset);
        return removed;
    }

    public abstract Node getRange(int var1, int var2);

    public abstract char getCharacterAt(int var1);

    public abstract int getCharacterCount();

    public abstract Node duplicate(boolean var1);

    protected void rangeInserted(int offset, int characterCount) {
        if (this.parent != null) {
            this.parent.rangeInserted(offset + this.offset, characterCount);
        }
        this.nodeListeners.rangeInserted(this, offset, characterCount);
    }

    protected void rangeRemoved(int offset, int characterCount) {
        if (this.parent != null) {
            this.parent.rangeRemoved(offset + this.offset, characterCount);
        }
        this.nodeListeners.rangeRemoved(this, offset, characterCount);
    }

    protected void nodesRemoved(Sequence<Node> removed, int offset) {
        if (this.parent != null) {
            this.parent.nodesRemoved(removed, offset + this.offset);
        }
        this.nodeListeners.nodesRemoved(this, removed, offset);
    }

    protected void nodeInserted(int offset) {
        if (this.parent != null) {
            this.parent.nodeInserted(offset + this.offset);
        }
        this.nodeListeners.nodeInserted(this, offset);
    }

    public ListenerList<NodeListener> getNodeListeners() {
        return this.nodeListeners;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeListenerList
    extends ListenerList<NodeListener>
    implements NodeListener {
        private NodeListenerList() {
        }

        @Override
        public void parentChanged(Node node, Element previousParent) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                NodeListener listener = (NodeListener)i$.next();
                listener.parentChanged(node, previousParent);
            }
        }

        @Override
        public void offsetChanged(Node node, int previousOffset) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                NodeListener listener = (NodeListener)i$.next();
                listener.offsetChanged(node, previousOffset);
            }
        }

        @Override
        public void nodeInserted(Node node, int offset) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                NodeListener listener = (NodeListener)i$.next();
                listener.nodeInserted(node, offset);
            }
        }

        @Override
        public void nodesRemoved(Node node, Sequence<Node> removed, int offset) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                NodeListener listener = (NodeListener)i$.next();
                listener.nodesRemoved(node, removed, offset);
            }
        }

        @Override
        public void rangeInserted(Node node, int offset, int span) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                NodeListener listener = (NodeListener)i$.next();
                listener.rangeInserted(node, offset, span);
            }
        }

        @Override
        public void rangeRemoved(Node node, int offset, int characterCount) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                NodeListener listener = (NodeListener)i$.next();
                listener.rangeRemoved(node, offset, characterCount);
            }
        }
    }
}

