
/**
 * WoodDistort.vert
 *
 * is a derived work of the Java3D example class 'DistortBehavior.java' and
 * the 3Dlabs vertex shader 'Wood1.vert'.
 '
 * Redistribution and use are permitted according to the following license notices.
 *
 * Version: 5.0 (FXDistortString)
 * Date: 2009/11/09
 *
 * Author:
 * August Lammersdorf, InteractiveMesh e.K.
 * Kolomanstrasse 2a, 85737 Ismaning
 * Germany / Munich Area
 * www.InteractiveMesh.com/org
 *
 */

/*
 * org.jdesktop.j3d.examples.distort_glyph.DistortBehavior.java
 *
 * Copyright (c) 2007 Sun Microsystems, Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * - Redistribution of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 *
 * - Redistribution in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in
 *   the documentation and/or other materials provided with the
 *   distribution.
 *
 * Neither the name of Sun Microsystems, Inc. or the names of
 * contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * This software is provided "AS IS," without a warranty of any
 * kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
 * WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
 * EXCLUDED. SUN MICROSYSTEMS, INC. ("SUN") AND ITS LICENSORS SHALL
 * NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF
 * USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
 * DERIVATIVES. IN NO EVENT WILL SUN OR ITS LICENSORS BE LIABLE FOR
 * ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT, SPECIAL,
 * CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER CAUSED AND
 * REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF OR
 * INABILITY TO USE THIS SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *
 * You acknowledge that this software is not designed, licensed or
 * intended for use in the design, construction, operation or
 * maintenance of any nuclear facility.
 *
 * $Revision: 1.2 $
 * $Date: 2007/02/09 17:21:36 $
 * $State: Exp $
 */

/************************************************************************
* Wood1.vert - Simple vertex shader for wood                            *
*                                                                       *
* Author: John Kessenich                                                *
*                                                                       *
*                                                                       *
*               Copyright (C) 2002-2006  3Dlabs Inc. Ltd.               *
*                                                                       *
*                        All rights reserved.                           *
*                                                                       *
* Redistribution and use in source and binary forms, with or without    *
* modification, are permitted provided that the following conditions    *
* are met:                                                              *
*                                                                       *
*     Redistributions of source code must retain the above copyright    *
*     notice, this list of conditions and the following disclaimer.     *
*                                                                       *
*     Redistributions in binary form must reproduce the above           *
*     copyright notice, this list of conditions and the following       *
*     disclaimer in the documentation and/or other materials provided   *
*     with the distribution.                                            *
*                                                                       *
*     Neither the name of 3Dlabs Inc. Ltd. nor the names of its         *
*     contributors may be used to endorse or promote products derived   *
*     from this software without specific prior written permission.     *
*                                                                       *
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS   *
* "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT     *
* LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS     *
* FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE        *
* COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, *
* INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,  *
* BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;      *
* LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER      *
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT    *
* LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN     *
* ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE       *
* POSSIBILITY OF SUCH DAMAGE.                                           *
*                                                                       *
************************************************************************/


//
uniform int IsDistortTexture;
// Updated per frame
uniform float Spx;
uniform float Spy;
//
uniform float Scale;

varying float LightIntensity;
varying vec3  Position;

mat3 distortMatNormal = mat3(1.0);
mat4 distortMatVertex = mat4(1.0);

void main(void) {
    
    float px = gl_Vertex.x - Spx;
    float py = gl_Vertex.y - Spy;
    float pz = gl_Vertex.z;
    
    float d = sqrt(px*px + py*py + pz*pz);
    
    float sinAngle = sin(d);
    float cosAngle = cos(d);
    
    // [column][row]
       
    // Rotation about Y-axis

    distortMatVertex[0][0] = cosAngle;
    distortMatVertex[0][2] = -sinAngle;
    
    distortMatVertex[2][0] = sinAngle;
    distortMatVertex[2][2] = cosAngle;

    // As distortMatNormal is orthogonal it transforms normals correctly
    // No need to inverse and transpose it

    distortMatNormal[0][0] = cosAngle;
    distortMatNormal[0][2] = -sinAngle;

    distortMatNormal[2][0] = sinAngle;
    distortMatNormal[2][2] = cosAngle;

    // Model space

    // Distort vertex coordinates
    vec4 distortVertex = distortMatVertex * gl_Vertex;
    // Distort normal vector
    vec3 distortNormal = distortMatNormal * gl_Normal;

    // Scaled (distort) vertex coordinates for fragment shader
    if (IsDistortTexture == 0) {
        Position = distortVertex.xyz * Scale;
    }
    else {
        Position = gl_Vertex.xyz * Scale;
    }
    

    // Normal in eye space
    vec3 normal = normalize(gl_NormalMatrix * distortNormal);
    // Scaled diffuse light
    LightIntensity = max(dot(normalize(gl_LightSource[0].position.xyz), normal), 0.0) * 1.5;

    gl_Position = gl_ModelViewProjectionMatrix * distortVertex;
}
