/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.loaders.vrml97.impl;

import java.util.Vector;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.DistanceLOD;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.Switch;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import org.jdesktop.j3d.loaders.vrml97.impl.BaseNode;
import org.jdesktop.j3d.loaders.vrml97.impl.DirectionalLight;
import org.jdesktop.j3d.loaders.vrml97.impl.Loader;
import org.jdesktop.j3d.loaders.vrml97.impl.MFFloat;
import org.jdesktop.j3d.loaders.vrml97.impl.MFNode;
import org.jdesktop.j3d.loaders.vrml97.impl.NonSharedNode;
import org.jdesktop.j3d.loaders.vrml97.impl.SFVec3f;

public class LOD
extends NonSharedNode {
    MFNode level;
    SFVec3f center;
    MFFloat range;
    Group impl;
    Switch implSwitch;
    DistanceLOD implLOD;

    public LOD(Loader loader) {
        super(loader);
        this.level = new MFNode();
        this.center = new SFVec3f();
        this.range = new MFFloat();
        this.initFields();
    }

    LOD(Loader loader, MFNode level, SFVec3f center, MFFloat range) {
        super(loader);
        this.level = level;
        this.center = center;
        this.range = range;
        this.initFields();
    }

    void initImpl() {
        this.impl = new Group();
        this.implSwitch = new Switch();
        this.implSwitch.setUserData(new Vector());
        if (this.range.mfloat.length >= 1) {
            this.implSwitch.setWhichChild(this.range.mfloat.length - 1);
            double furthest = this.range.mfloat[this.range.mfloat.length - 1];
            this.implSwitch.setCapability(17);
            this.implSwitch.setCapability(18);
            this.implSwitch.setUserData(new Vector());
            Point3f lodCenter = new Point3f(this.center.value[0], this.center.value[1], this.center.value[2]);
            this.implLOD = new DistanceLOD(this.range.mfloat, lodCenter);
            this.implLOD.addSwitch(this.implSwitch);
            Point3d boundCenter = new Point3d(lodCenter);
            this.implLOD.setSchedulingBounds((Bounds)new BoundingSphere(boundCenter, furthest * 1.1));
            this.impl.addChild((Node)this.implLOD);
        } else {
            this.implSwitch.setWhichChild(0);
        }
        this.impl.addChild((Node)this.implSwitch);
        this.replaceLevels();
        this.implNode = this.impl;
        this.implReady = true;
    }

    void replaceLevels() {
        int i;
        int numChildren = this.implSwitch.numChildren();
        if (numChildren != 0) {
            i = 0;
            while (i < numChildren) {
                this.implSwitch.removeChild(0);
                ++i;
            }
        }
        i = 0;
        while (i < this.level.nodes.length) {
            BaseNode child = this.level.nodes[i];
            child.updateParent((Node)this.implSwitch);
            Node implNode = child.getImplNode();
            if (this.loader.debug) {
                System.out.println(String.valueOf(this.toStringId()) + ":  index = " + i + " child node type is " + child.getType() + " " + child.toStringId() + " gets implNoded to " + implNode);
            }
            if (implNode != null) {
                if (implNode.getParent() == null) {
                    this.implSwitch.addChild(implNode);
                } else {
                    this.implSwitch.addChild(implNode.cloneNode(true));
                }
                if (child instanceof DirectionalLight) {
                    DirectionalLight dirLight = (DirectionalLight)child;
                    dirLight.setScope((Group)this.implSwitch);
                }
            }
            ++i;
        }
    }

    public int getNumTris() {
        BaseNode child;
        int numTris = 0;
        if (this.level.nodes.length > 0 && (child = this.level.nodes[0]) != null) {
            numTris += child.getNumTris();
        }
        return numTris;
    }

    public void notifyMethod(String eventInName, double time) {
        if (eventInName.equals("level")) {
            this.replaceLevels();
        }
    }

    public Object clone() {
        return new LOD(this.loader, (MFNode)this.level.clone(), (SFVec3f)this.center.clone(), (MFFloat)this.range.clone());
    }

    public String getType() {
        return "LOD";
    }

    void initFields() {
        this.level.init(this, this.FieldSpec, 3, "level");
        this.center.init(this, this.FieldSpec, 0, "center");
        this.range.init(this, this.FieldSpec, 0, "range");
    }
}

